class Popit extends Rocket;

var ParticleGenerator fireGen;
var ParticleGenerator sparkGen;

simulated function DrawExplosionEffects(vector HitLocation, vector HitNormal)
{
          local ProjectileGenerator P;
          local int I;

  super.DrawExplosionEffects(HitLocation,HitNormal);
  I = Rand(5);
  P = Spawn(Class'ProjectileGenerator',,,HitLocation);
  if (P != none)
  {
    P.RemoteRole = ROLE_None;
    P.checkTime = 0.05;
	P.frequency = 1.0;
	P.ejectSpeed = 500.0;
	P.bRandomEject = True;
	P.LifeSpan = 2.0;
    switch(I)
    {
      case 0:
      P.ProjectileClass = class'MiniRedFire';
      break;
      case 1:
      P.ProjectileClass = class'MiniBlueFire';
      break;
      case 2:
      P.ProjectileClass = class'MiniYellowFire';
      break;
      case 3:
      P.ProjectileClass = class'MiniGreenFire';
      break;
      case 4:
      P.ProjectileClass = class'MiniGrayFire';
      break;
    }
  }
}

defaultproperties
{
     mpBlastRadius=32.000000
     bBlood=False
     blastRadius=32.000000
     DamageType=Burned
     ItemName="Popit"
     speed=1500.000000
     Damage=0.000000
     MomentumTransfer=0
     SpawnSound=None
     Physics=PHYS_Falling
     Mesh=LodMesh'DeusExItems.Rockchip1'
     DrawScale=0.300000
     AmbientSound=None
     CollisionRadius=2.000000
     CollisionHeight=2.000000
     bBounce=True
     bFixedRotationDir=True
}
